using gov.va.med.vbecs.Common;
using System;
using System.Linq;

namespace gov.va.med.vbecs.BOL
{
    /// <summary>
    /// PendingSpecimenAntigenTypingModel
    /// </summary>
    public class PendingSpecimenAntigenTypingModel : PendingTestModel, IPendingSpecimenTestModel
    {
        /// <summary>
        /// PatientSpecimenGuid
        /// </summary>
        public Guid PatientSpecimenGuid { get; set; }
        /// <summary>
        /// SpecimenUid
        /// </summary>
        public string SpecimenUid { get; set; }
        /// <summary>
        /// OrderedTest
        /// </summary>
        public OrderedTest OrderedTest { get; set; }
        /// <summary>
        /// SpecimenResultSetGuid
        /// </summary>
        public Guid ResultSetGuid { get; set; }
        /// <summary>
        /// SpecimenExpirationDate
        /// </summary>
        public DateTime? SpecimenExpirationDate { get; set; }
        /// <summary>
        /// CprsOrderNumber
        /// </summary>
        public string CprsOrderNumber { get; set; }
        /// <summary>
        /// InterpText
        /// </summary>
        public override string InterpText
        {
            get
            {
                if (Interp != null)
                {
                    return Interp.TestResultText;
                }

                return "";
            }
        }
        /// <summary>
        /// WorkloadProcessID
        /// </summary>
        public override WorkloadProcessID WorkloadProcessId
        {
            get
            {
                return WorkloadProcessID.AutomatedPatientAntigenTyping;
            }
        }
        /// <summary>
        /// CheckCell
        /// </summary>
        public PendingTestResultModel CheckCell
        {
            get
            {
                return GetPendingTestResult(TestType.Anti_Dc_AHG, false);
            }
        }
        /// <summary>
        /// Result
        /// </summary>
        public PendingTestResultModel Result
        {
            get
            {
                return TestResultList.FirstOrDefault(x => !x.IsInterp && x.TestType != TestType.Anti_Dc_AHG);
            }
        }
        /// <summary>
        /// Interp
        /// </summary>
        public PendingTestResultModel Interp
        {
            get
            {
                return TestResultList.FirstOrDefault(x => x.IsInterp);
            }
        }

        /// <summary>
        /// Validate Test
        /// </summary>
        public TestValidationModel Validate()
        {
            if (OrderableTest.IsWeakD)
            {
                return BOL.TestValidation.ValidatePatientWeakD(
                            Result == null ? string.Empty : Result.TestResultId,
                            CheckCell == null ? string.Empty : CheckCell.TestResultId,
                            Interp == null ? string.Empty : Interp.TestResultId,
                            OrderedTest,
                            SpecimenExpirationDate);
            }
            else
            {
                return BOL.TestValidation.ValidatePatientAntigentyping(
                            Result == null ? string.Empty : Result.TestResultId,
                            Interp == null ? string.Empty : Interp.TestResultId,
                            OrderedTest,
                            SpecimenExpirationDate);
            }
        }
    }
}



